//#declare tex_simp = 1
//#declare sky_simp = 1
//#declare no_tubes = 1
//#declare img_map_simp = 1
//#declare tube_simp = 1
//---------------------------------------------Includes---------------------------------------------
#include "colors.inc"
#include "DanzTex.inc"
//#include "textures.inc"
//#include "stones.inc"
//#include "metals.inc"
#include "glass.inc"
//#include "woods.inc"
//---------------------------------------------Background---------------------------------------------
background{rgb 1}
#ifndef (sky_simp)
#include "skies.inc"
sky_sphere{S_Cloud2}
#end
//---------------------------------------------Clock---------------------------------------------
#declare clk = 0 //clock
//---------------------------------------------Camera(s)---------------------------------------------
#declare Main_Cam =camera{location<0,10,-15>look_at<0,0,0>}
#declare Rom_Cam =camera{location<0,15,-17>look_at<0,6,0>}
camera{Rom_Cam}
//---------------------------------------------Lighting---------------------------------------------
light_source{<20,40,-20> 1}
light_source{<-10,25,-20> 1}
light_source{<0,0.01,-200> 0.5}
//---------------------------------------------Textures---------------------------------------------
#ifdef(tex_simp)
default{pigment{rgb x}}
#declare Floor_Tex = texture{pigment{rgb <1,1,0>}}
#declare Main_Glass_Tex = texture{pigment{rgb 0.5}}
#declare Table_Top_Tex = texture{pigment{rgb x}}
#declare Table_Leg_Tex = texture{pigment{rgb y}}
#else
default{pigment{rgb x}finish{phong 0.9 phong_size 60}}
#declare Floor_Tex = texture{DentedMetal}
#declare Main_Glass_Tex = texture{T_Glass3}
#declare Table_Top_Tex = texture{PlyWood}
#declare Table_Leg_Tex = texture{DeepWood rotate -89*x scale 0.4}
#end
#include "Flask.inc"
#include "Beaker.inc"
#include "TestTubes.inc"
#include "Tube.inc"
#include "RingStand.inc"
//----------------------------------------------Stuff-----------------------------------------------
#declare Table = union{
#declare scalez = 0.5
union{
cylinder{0.75*y,-0.75*y,10}
torus{10,0.75}
texture{Table_Top_Tex}
scale<1,1,scalez+0.2>
}
union{
#declare cnt = 0
#declare endcnt = 10
#while(cnt<endcnt)
#declare Prog = cnt/endcnt
#declare pnt4 = vrotate(9*x,360*Prog*y)
cylinder{0,-100*y,1 translate pnt4*x+pnt4*y+pnt4*z*scalez}
#declare cnt = cnt + 1
#end
texture{Table_Leg_Tex}
}
translate -0.75*y
}

#declare Chunk = union{
object{Flask scale 0.6 translate -6*x-4*z}
object{Beaker scale<1,1.25,1> translate 1.5*y+0.75*x}
object{TestTubeRack scale 0.6 rotate 40*y translate 7*x+2*z}
object{Tube scale <0.4,0.3,0.3> rotate 20*y translate -5.5*z+1*x}
object{Ring_Stand}
translate -0.5*x
scale 0.9
}
union{
object{Chunk}
object{Table}
translate 6*y
}
plane{y,0 texture{Floor_Tex}}

